/******************************************************************************
 *
 * Copyright (c) 2013 TP-LINK Technologies CO.,LTD.
 * All rights reserved.
 *
 * FILE NAME  :   gpio_led.h
 * VERSION    :   1.0
 * DESCRIPTION:   APIs which control LED on/off/blinking.
 *
 * AUTHOR     :   Teng Fei <tengfei@tp-link.net>
 * CREATE DATE:   04/25/2013
 *
 * HISTORY    :
 * 01   04/25/2013  Teng Fei     Create.
 *
 ******************************************************************************/

#ifndef	_GPIO_LED_H
#define	_GPIO_LED_H

//#include <configs/product_cfg.h>		/* PRODUCT_GPIO_FEATURE */

#include <common.h>
#include <rt_mmap.h>

#ifdef	PRODUCT_GPIO_FEATURE

/*
**	Address of RALINK_ Registers
*/
/* system control */
#define RALINK_SYSCTL_ADDR			RALINK_SYSCTL_BASE
#define RALINK_REG_GPIOMODE		(RALINK_SYSCTL_ADDR + 0x60)

/* Programmable I/O */
#define RALINK_PRGIO_ADDR			RALINK_PIO_BASE

#define RALINK_REG_PIOINT		(RALINK_PRGIO_ADDR + 0x00)
#define RALINK_REG_PIOEDGE		(RALINK_PRGIO_ADDR + 0x04)
#define RALINK_REG_PIORENA		(RALINK_PRGIO_ADDR + 0x08)
#define RALINK_REG_PIOFENA		(RALINK_PRGIO_ADDR + 0x0C)
#define RALINK_REG_PIODATA		(RALINK_PRGIO_ADDR + 0x20)
#define RALINK_REG_PIODIR		(RALINK_PRGIO_ADDR + 0x24)
#define RALINK_REG_PIOSET		(RALINK_PRGIO_ADDR + 0x2C)
#define RALINK_REG_PIORESET		(RALINK_PRGIO_ADDR + 0x30)
#define RALINK_REG_PIOTOGGLE		(RALINK_PRGIO_ADDR + 0x34)


#define RALINK_REG_PIO3924INT		(RALINK_PRGIO_ADDR + 0x38)
#define RALINK_REG_PIO3924EDGE		(RALINK_PRGIO_ADDR + 0x3C)
#define RALINK_REG_PIO3924RENA		(RALINK_PRGIO_ADDR + 0x40)
#define RALINK_REG_PIO3924FENA		(RALINK_PRGIO_ADDR + 0x44)
#define RALINK_REG_PIO3924DATA		(RALINK_PRGIO_ADDR + 0x48)
#define RALINK_REG_PIO3924DIR		(RALINK_PRGIO_ADDR + 0x4C)
#define RALINK_REG_PIO3924POL		(RALINK_PRGIO_ADDR + 0x50)
#define RALINK_REG_PIO3924SET		(RALINK_PRGIO_ADDR + 0x54)
#define RALINK_REG_PIO3924RESET		(RALINK_PRGIO_ADDR + 0x58)
#define RALINK_REG_PIO3924TOGGLE	(RALINK_PRGIO_ADDR + 0x5C)

#define RALINK_REG_PIO7140INT		(RALINK_PRGIO_ADDR + 0x60)
#define RALINK_REG_PIO7140EDGE		(RALINK_PRGIO_ADDR + 0x64)
#define RALINK_REG_PIO7140RENA		(RALINK_PRGIO_ADDR + 0x68)
#define RALINK_REG_PIO7140FENA		(RALINK_PRGIO_ADDR + 0x6C)
#define RALINK_REG_PIO7140DATA		(RALINK_PRGIO_ADDR + 0x70)
#define RALINK_REG_PIO7140DIR		(RALINK_PRGIO_ADDR + 0x74)
#define RALINK_REG_PIO7140POL		(RALINK_PRGIO_ADDR + 0x78)
#define RALINK_REG_PIO7140SET		(RALINK_PRGIO_ADDR + 0x7C)
#define RALINK_REG_PIO7140RESET		(RALINK_PRGIO_ADDR + 0x80)
#define RALINK_REG_PIO7140TOGGLE	(RALINK_PRGIO_ADDR + 0x84)

#define RALINK_REG_PIO72INT		(RALINK_PRGIO_ADDR + 0x88)
#define RALINK_REG_PIO72EDGE		(RALINK_PRGIO_ADDR + 0x8C)
#define RALINK_REG_PIO72RENA		(RALINK_PRGIO_ADDR + 0x90)
#define RALINK_REG_PIO72FENA		(RALINK_PRGIO_ADDR + 0x94)
#define RALINK_REG_PIO72DATA		(RALINK_PRGIO_ADDR + 0x98)
#define RALINK_REG_PIO72DIR		(RALINK_PRGIO_ADDR + 0x9C)
#define RALINK_REG_PIO72POL		(RALINK_PRGIO_ADDR + 0xA0)
#define RALINK_REG_PIO72SET		(RALINK_PRGIO_ADDR + 0xA4)
#define RALINK_REG_PIO72RESET		(RALINK_PRGIO_ADDR + 0xA8)
#define RALINK_REG_PIO72TOGGLE		(RALINK_PRGIO_ADDR + 0xAC)


/*
**	GPIOMODE value to control pin mode.
*/
#define RALINK_GPIOMODE_I2C			0x01
#define RALINK_GPIOMODE_UARTF			0x1C
#define RALINK_GPIOMODE_UARTL			0x20
#define RALINK_GPIOMODE_JTAG			0x40
#define RALINK_GPIOMODE_MDIO			0x180
#define RALINK_GPIOMODE_GE1			0x200
#define RALINK_GPIOMODE_GE2			0x400
#define RALINK_GPIOMODE_SPI			0x800
#define RALINK_GPIOMODE_SPI_REFCLK	0x1000
#define RALINK_GPIOMODE_WLED			0x2000
#define RALINK_GPIOMODE_EPHY			0x8000
#define RALINK_GPIOMODE_PERST			0x20000
#define RALINK_GPIOMODE_ND_SD			0x80000
#define RALINK_GPIOMODE_PA_G			0x100000
#define RALINK_GPIOMODE_WDT			0x400000

#define RALINK_GPIOMODE_DFT			(RALINK_GPIOMODE_I2C) | (RALINK_GPIOMODE_UARTF)


/*
**	gpio number of  LEDs ...
*/
#if defined(PRODUCT_GPIO_WA855RE)
	/* RED indicates that system is up */
	#define RALINK_LED_RED_GPIO_NUM		42
	/* YELLOW indicates that wifi signal is weak */
	#define RALINK_LED_YELLOW_GPIO_NUM	40
	/* GREEN indicates that wifi has been connected and its signal is strong */
	#define RALINK_LED_GREEN_GPIO_NUM	72
#elif defined(PRODUCT_GPIO_WA3500RE)
	/* 2.4G WLAN  (kelly or red color) */
	#define	RALINK_LED_2G1_GPIO_NUM		2
	#define	RALINK_LED_2G2_GPIO_NUM		72
	/* wps led or wifi led */
	#define	RALINK_LED_WPS_GPIO_NUM		25
	#define	RALINK_LED_WIFI_GPIO_NUM		27
	/* Leds on/off switch control */
	#define	RALINK_LED_SWITCH_GPIO_NUM	24
#elif defined(PRODUCT_GPIO_RE200)
	/* 2.4G WLAN  (kelly or red color) */
	#define	RALINK_LED_2G1_GPIO_NUM		2
	#define	RALINK_LED_2G2_GPIO_NUM		72
	/* wps led or wifi led */
	#define	RALINK_LED_WPS_GPIO_NUM		39
	#define	RALINK_LED_WIFI_GPIO_NUM		27
	/* Leds on/off switch control */
	#define	RALINK_LED_SWITCH_GPIO_NUM	24
#elif defined(PRODUCT_GPIO_WR810N)
	#define	RALINK_LED_SYS_GPIO_NUM		72
	#define	RALINK_BTN_RST_GPIO_NUM		2
#else
#endif

#define RALINK_GPIO(x)			(1 << x)

void blinkLed(void);

void gpio_led_set
(
	const unsigned int,
	const unsigned int
);
#endif	/* PRODUCT_GPIO_FEATURE */

/* GPIO Pin DIR valid value */
#define TP_GPIO_DIR_OUT_VALUE			1
#define TP_GPIO_DIR_IN_VALUE			0

#define TP_GPIO_LED_ON					0
#define TP_GPIO_LED_OFF					1



#ifdef	FW_RECOVERY
#if defined(PRODUCT_GPIO_WR810N)
	#define	FW_BTN_GPIO_ADDR		(RALINK_PRGIO_ADDR + 0x20)
	#define	FW_BUTTON_GPIO_NUM	RALINK_BTN_RST_GPIO_NUM
	#define	FW_LED_GPIO_NUM		RALINK_LED_SYS_GPIO_NUM
#else
	#error undefined
#endif

int gpio_indicate_fw_rcv(void);
#endif	/* FW_RECOVERY */



void tplink_init_gpio_reg();
void tplink_turn_on_led();
void tplink_turn_off_led();
void tplink_led_blink();

void tplink_gpio_datareg_set(int dataPin, int pinValue);


#endif	/* _GPIO_LED_H */

